extensions [ nw ]
globals [ centralities 
          leader
          leader-news
          ]
turtles-own
[
  source
  belong-to   ;;news belong to whome
  centrality
  newscolor   ;;initial news color red
  nodecolor   ;;original color
  user-name
  num-of-news
  tag
]


breed [news a-news]
breed [people node]
breed [mouse mice]

mouse-own
[click
  ]

;;red 15, pink 135, blue 105, yellow 45

to startup
  hubnet-reset
end

to setup
  clear-all
  create-people 1 [set color 15 set nodecolor 15 set shape "circle" set size 0.6 set user-name "computer 0" set tag 0]
  create-people 1 [set color 15 set nodecolor 15 create-link-with turtle 0 set shape "circle" set size 0.6 set user-name "computer 1" set tag 0]
  
  
  ask one-of turtles[set color 135]
  let newscreater turtles with [color = 135]
  nw:set-snapshot turtles links
  cal-centrality newscreater
  setup-news 
  ask news [put-ontop]
  set centralities []
  set leader ""
  set leader-news 0
  ;set centralities fput [centrality] of newscreater centralities
  ;set noderead fput 1 noderead
  reset-ticks
end
  
;;prefential attachment
to setup-initial-network [old-node]
  
  create-people 1
  [
    set color 15
    set user-name hubnet-message-source
    set nodecolor 15
    set num-of-news 0
    set tag 1
    set shape "circle"
    set size 0.6
    if old-node != nobody
      [ create-link-with old-node 
        ;; position the new node near its partner
        move-to old-node
        fd 8
      ]
  ]
    
  
end

to-report find-partner
  let total random-float sum [count link-neighbors] of turtles
  let partner nobody
  ask turtles
  [
    let nc count link-neighbors
    ;; if there's no winner yet...
    if partner = nobody
    [
      ifelse nc > total
        [ set partner self ]
        [ set total total - nc ]
    ]
  ]
  report partner
end
;;;;;;;;;;;;;;;;;;;;;;;;;

to setup-news
  create-news 1
  [ 
    set shape "square"
    set color 45  ;;yellow
    set newscolor 15
    set num-of-news 0
    set size 1
    set source one-of turtles with [color = 135]
    ]
  let temp one-of turtles with [color = 135]
  ask news [move-to temp set belong-to temp]
   
end

to spreadnews
  listen-clients
   ifelse ticks mod 4 = 0 and ticks > 0
  [
    let countgreen count people with [color = 65]
    let countpink count people with [color = 135]
    let countgrey count people with [color = 9]
    let countsame countgreen + countpink
    let countdiff countgrey
    let countread countsame + countdiff
    let creater [source] of one-of news
    ;;set noderead fput countread noderead
    
    set centralities fput(list [centrality] of creater countread) centralities
    ask news [die]
  ask turtles [set color nodecolor]
  ask one-of people [set color 135]
  let newscreater turtles with [color = 135]
  setup-news
  cal-centrality newscreater
  ;set centralities fput [centrality] of newscreater centralities
  ]
  
  [
  ask turtles with [color = 135]
  [
    
    while [count link-neighbors with [color = 15 or color = 105] > 0]
    [
    let spread one-of link-neighbors with [color != 135] ;;node we are going to spread
    let parent one-of turtles-here with [color = 45]  ;;news to be spread
    
    if spread != nobody [
      
      ifelse [newscolor] of parent = [color] of spread
      [
        ask spread [set color 65 set num-of-news num-of-news + 1]      ;; the people with same opinion read the news green
      if random-float 100 < news-is-interesting [
        ask spread [set color 135]
        ask parent[hatch 1]
        ask parent [move-to spread set belong-to spread]
        ]] 
      [
        ask spread [set color 9]     ;; the people with different opinion read the news grey
        ]
    ]
    ]
    ]
  ]
  update-leader-stats
  ask people with [user-name = hubnet-message-source]
  [send-student-info]
  tick
  
end



to put-ontop
  hatch 1;;[create-links-with [links]of myself]
  die
end

to layout
  ;; the number 3 here is arbitrary; more repetitions slows down the
  ;; model, but too few gives poor layouts
  repeat 3 [
    ;; the more turtles we have to fit into the same amount of space,
    ;; the smaller the inputs to layout-spring we'll need to use
    let factor sqrt count turtles
    ;; numbers here are arbitrarily chosen for pleasing appearance
    layout-spring turtles links (1 / factor) (7 / factor) (1 / factor)
    display  ;; for smooth animation
  ]
  ;; don't bump the edges of the world
  let x-offset max [xcor] of turtles + min [xcor] of turtles
  let y-offset max [ycor] of turtles + min [ycor] of turtles
  ;; big jumps look funny, so only adjust a little each time
  set x-offset limit-magnitude x-offset 0.1
  set y-offset limit-magnitude y-offset 0.1
  ask turtles [ setxy (xcor - x-offset / 2) (ycor - y-offset / 2) ]
  ask news [move-to [belong-to] of self]
end

to-report limit-magnitude [number limit]
  if number > limit [ report limit ]
  if number < (- limit) [ report (- limit) ]
  report number
end

to resize-nodes
  ifelse all? turtles [size <= 1]
  [
    ;; a node is a circle with diameter determined by
    ;; the SIZE variable; using SQRT makes the circle's
    ;; area proportional to its degree
    ask turtles [ set size sqrt count link-neighbors ]
  ]
  [
    ask turtles [ set size 1 ]
  ]
end

to cal-centrality [choice]
  ifelse centrality-measure = "degree-centrality"
  [ask choice [ 
        set centrality count my-links
      ]
    ]
  [
    ask choice[
  set centrality runresult (word "nw:" centrality-measure)
  ]
  ]
  ;;report [centrality] of choice
end

to cal-local-cluster [choice]
  ask choice
  [let num-nei one-of link-neighbors with [color = 15]
    
    ]
end

to two-color
  ask people with [who mod 2 = 0]
  [ 
    if color != 135
    [
    set color 105
    set nodecolor 105
    ]
    ]
  
end


to listen-clients
  while [hubnet-message-waiting?]
  [
    hubnet-fetch-message
    ifelse hubnet-enter-message?
    [ add-node ]
    [
      ifelse hubnet-exit-message?
     [ remove-node ]
     [
        if hubnet-message-tag = "View"  ;;?????
        [
          ask people with [ user-name = hubnet-message-source ]
            [ change-connect ]
        ]
      ]
    ]
  ]
  
end

to change-connect
  let clicked-xcor  (item 0 hubnet-message)
  let clicked-ycor  (item 1 hubnet-message)
  ask mouse with [ user-name = hubnet-message-source ]
  [
    set xcor clicked-xcor      ;; go to the location of the click
    set ycor clicked-ycor
    set click people in-radius 1
    
  ]
  ask people with [ user-name = hubnet-message-source ]
  [
    if one-of first [click] of mouse with [user-name = hubnet-message-source] != nobody
    [
    ifelse first [link-neighbor? one-of first [click] of mouse with [user-name = hubnet-message-source]] of people with [ user-name = hubnet-message-source ]
    [
      ask link-with one-of first [click] of mouse with [user-name = hubnet-message-source] [die]
    ]
    
    [ if count link-neighbors < allowed-link
      [
      create-link-with one-of first [click] of mouse with [user-name = hubnet-message-source]
      ]
    ]
    
    ]
   ]
  
  
end

to add-node
  setup-initial-network find-partner
  create-mouse 1
  [
    set user-name hubnet-message-source
    set color black
    
    ]
end

to remove-node
  ask people with [ user-name = hubnet-message-source ]
    [ die ]
end

to update-leader-stats
  let leaders people with [tag = 1]with-max [num-of-news]
  let number-leaders count leaders
  if one-of leaders != nobody
  [
  ifelse number-leaders > 1
    [ set leader word number-leaders "-way tie" ]
    [ ask one-of leaders [ set leader user-name ] ]
  set leader-news [num-of-news] of one-of leaders
  ]
end

to send-student-info ;; player procedure
  hubnet-send user-name  "Your name" user-name
  hubnet-send user-name "Number of news you received" num-of-news
  hubnet-send user-name "Top Twitterer" leader
  hubnet-send user-name "Top twitterer's news" leader-news
end
@#$#@#$#@
GRAPHICS-WINDOW
502
15
998
520
40
39
6.0
1
10
1
1
1
0
1
1
1
-40
40
-39
39
1
1
1
ticks
30.0

BUTTON
21
152
84
185
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
20
65
193
98
news-is-interesting
news-is-interesting
0
100
38
1
1
%
HORIZONTAL

PLOT
223
188
423
367
num people read news vs tick
tick
# of people read news
0.0
20.0
0.0
200.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot count turtles with [color = pink or color = 69]"

BUTTON
21
193
116
226
redo layout
layout
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
21
235
123
268
NIL
resize-nodes
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

CHOOSER
20
13
192
58
centrality-measure
centrality-measure
"degree-centrality" "betweenness-centrality" "eigenvector-centrality" "closeness-centrality" "random"
0

PLOT
223
12
474
180
num people read news vs Centrality
Centrality
# People read news
0.0
0.0010
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 2 -16777216 true "" "if length centralities > 0\n[\nplotxy first first centralities last first centralities\n]"

BUTTON
21
278
104
311
NIL
two-color
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
21
323
119
356
NIL
spreadnews
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
21
366
150
399
spreadnews-once
spreadnews
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
223
375
309
420
Top twitterer
leader
17
1
11

MONITOR
223
434
407
479
number of top twitterer's news
leader-news
17
1
11

SLIDER
20
107
194
140
allowed-link
allowed-link
0
10
4
1
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

This model is a HubNet activity complement to NetLogo model. We simulated social network sites. Each node represent a people in Online Social Network like twitter or facebook. The goal for this activity is to receive the largest number of news from network.


## HOW IT WORKS

Each participate student is a node in the network. They can use their mouse in client to choose the people they want to follow (connect). They can relick that people to not follow him (disconnect). In this case the network will be a truly dynamic network where every one want to optimise their own network.

We set the maximum possible number of people that one can follow. So that he has to make a choice.

There is a life time for news. At the begining of life cycle, we will randomly pick a people as news creater.
Rule for network growth: In each tick, every people that feels the news is interesting will twitter the news. We use a possibility to describe the agent behavior of “feeling interesting”. The news will be twittered to all the neighbors of the one who retwitter the news and these neighbors will read the news. If they feel the news is interesting, the will retwitter the news in next tick and they will follow the news creater. In this way the number of follower of the news creater increase.

Rule for news spread: The rule is similar to network growth. The only difference is in this situation those people retwitte the news won’t follow the new creater. We use this mechanism to see how news being spread in a stable network.

Rule for two different opinion: If we have two group of people with totally different opinion. Those people with different opinion will read the news and ignore it (never retwitter).

## HOW TO USE IT

Centrality: Decide use which kind of centrality measurement
News-is-interesting: Determing the probability of retwitter
allowed link: the maximum number of people each person can follow
News-life: The life cycle of news
Setup: Initialize a scale free network according to preferential attachment.
Redo layour: Layout the network according to its connectivility.
resize node: resize the node according to the number of neighbors
two-color: split the entire graph into two groups with different opinions. We use this buttom to start simluate news spread between two groups.
Spreadnews: Forever running buttom to spread the news on network
Spreadnews-once: run spread one tick

Top twitter: the name of the client who received the largest number of news

## THINGS TO NOTICE

Please do the activity according to the following sequence:

1. setup network

2. let all user login to the server

3. click Spreadnews buttom to start news

This model use the NW extension. You can download the extension from “https://github.com/NetLogo/NW-Extension” 

## THINGS TO TRY

Try to adjust the allower number of links

## EXTENDING THE MODEL

A possible further entension is to allow client to communicate so that this activity looks more like a real social network.

## NETLOGO FEATURES

This model use the NW extension. Besides, the implementation use loop as flow control and list as data structure.

## RELATED MODELS

There is a NetLogo Model direct related to this model. In the literature there are Rumer Propogating model which is related to this model.


## CREDITS AND REFERENCES

You can find more about this model on modeling common.“http://modelingcommons.org/”
Paper reference:

[1] Dechun Liu; Xi Chen, “Rumor Propagation in Online Social Networks Like Twitter – A Simulation Study,” Multimedia Information Networking and Security (MINES), 2011 Third International Conference on , vol., no., pp.278,282, 4-6 Nov. 2011
 [2] Barabási, A.L., R. Albert, and H. Jeong, Mean-field theory for scalefree random networks. Physica A: Statistical Mechanics and its Applications, 1999. 272(1-2): p. 173-187.
[3] Suh, B.; Lichan Hong; Pirolli, P.; Chi, Ed H., “Want to be Retweeted? Large Scale Analytics on Factors Impacting Retweet in Twitter Network,” Social Computing (SocialCom), 2010 IEEE Second International Conference on , vol., no., pp.177,184, 20-22 Aug. 2010
 [4] Stonedahl, Forrest, Rand, William M. and Wilensky, Uri, Evolving Viral Marketing Strategies (July 2010). GECCO 2010, Portland, Oregon, USA, July 7-11, 2010 ; Robert H. Smith School Research Paper No. RHS 06-133.
 [5] Joseph J. Pfeiffer , Jennifer Neville, Methods to Determine Node Centrality and Clustering in Graphs with Uncertain Structure, Fifth International AAAI Conference on Weblogs and Social Media. 9 pages, 4 Figures, 2 Apr 2011
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
VIEW
199
33
685
507
0
0
0
1
1
1
1
1
0
1
1
1
-40
40
-39
39

MONITOR
9
34
81
83
Your name
NIL
3
1

MONITOR
9
93
187
142
Number of news you received
NIL
3
1

MONITOR
9
157
97
206
Top Twitterer
NIL
3
1

MONITOR
9
220
135
269
Top twitterer's news
NIL
3
1

@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
